% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{initCholReg_spam}
\alias{initCholReg_spam}
\title{Compute initial Cholesky decomposition for TVP Regression}
\usage{
initCholReg_spam(obs_sigma_t2, evol_sigma_t2, XtX, D = 1)
}
\arguments{
\item{obs_sigma_t2}{the \code{T x 1} vector of observation error variances}

\item{evol_sigma_t2}{the \code{T x p} matrix of evolution error variances}

\item{XtX}{the \code{Tp x Tp} matrix of X'X (one-time cost; see ?build_XtX)}

\item{D}{the degree of differencing (one or two)}
}
\description{
Computes the Cholesky decomposition for the quadratic term in the (Gaussian) posterior
of the TVP regression coefficients. The sparsity pattern will not change during the
MCMC, so we can save computation time by computing this up front.
}
