% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abco.R
\name{abco}
\alias{abco}
\title{Adaptive Bayesian Changepoint with Outliers}
\usage{
abco(
  y,
  D = 1,
  useAnom = TRUE,
  obsSV = "const",
  nsave = 1000,
  nburn = 1000,
  nskip = 4,
  mcmc_params = list("mu", "omega", "yhat", "evol_sigma_t2", "r", "zeta", "obs_sigma_t2",
    "zeta_sigma_t2", "dhs_phi", "dhs_mean", "h", "h_smooth"),
  verbose = TRUE,
  D_asv = 1,
  evol_error_asv = "HS",
  nugget_asv = TRUE
)
}
\arguments{
\item{y}{the \code{T} vector of time series observations}

\item{D}{degree of differencing (D = 1, or D = 2)}

\item{useAnom}{logical; if TRUE, include an anomaly component in the observation equation}

\item{obsSV}{Options for modeling the error variance. It must be one of the following:
\itemize{
\item const: Constant error variance for all time points.
\item SV: Stochastic Volatility model.
\item ASV: Adaptive Stochastic Volatility model.
}}

\item{nsave}{number of MCMC iterations to record}

\item{nburn}{number of MCMC iterations to discard (burnin)}

\item{nskip}{number of MCMC iterations to skip between saving iterations,
i.e., save every (nskip + 1)th draw}

\item{mcmc_params}{named list of parameters for which we store the MCMC output;
must be one or more of:
\itemize{
\item "mu" (conditional mean)
\item "omega" (Dth difference of mu)
\item "yhat" (posterior predictive distribution)
\item "evol_sigma_t2" (evolution error variance)
\item "obs_sigma_t2" (observation error variance)
\item "zeta_sigma_t2" (outlier error variance)
\item "dhs_phi" (DHS AR(1) coefficient)
\item "dhs_mean" (DHS AR(1) unconditional mean)
\item "h" (log variances or log of \code{"obs_sigma_t2"}. Only used when \code{obsSV = "ASV"})
\item "h_smooth" (smooth estimate of log variances. Only used when \code{obsSV = "ASV"} and \code{nugget_asv = TRUE})
}}

\item{verbose}{logical; should R report extra information on progress?}

\item{D_asv}{integer; degree of differencing (0, 1, or 2) for the ASV model. Only used when \code{obsSV = "ASV"}.}

\item{evol_error_asv}{character; evolution error distribution for the ASV model. Must be one of the five options used in \code{evol_error}. Only used when \code{obsSV = "ASV"}.}

\item{nugget_asv}{logical; if \code{TRUE}, fits the nugget variant of the ASV model. Only used when \code{obsSV = "ASV"}.}
}
\value{
A named list of the \code{nsave} MCMC samples for the parameters named in \code{mcmc_params}
}
\description{
Run the MCMC sampler for ABCO with a penalty on
first (D = 1), or second (D = 2) differences of the conditional expectation.
The penalty utilizes the dynamic horseshoe prior on the evolution errors.
Sampling is accomplished with a (parameter-expanded) Gibbs sampler,
mostly relying on a dynamic linear model representation.
}
