% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.r
\name{eval_poly}
\alias{eval_poly}
\title{Evaluate a polynomial}
\usage{
eval_poly(coeff, x)
}
\arguments{
\item{coeff}{A coefficient vector in increasing order of degrees;
the first element is 0th degree, ..., and the last element is the largest
degree of coefficients.}

\item{x}{A numeric input vector.}
}
\value{
A vector of values of a polynomial whose coefficient is \code{coeff}.
}
\description{
Evaluate the polynomial whose coefficients are represented in
\code{coeff} vector. The order of the coefficient is an increasing order, i.e.,
\code{coeff[1]} is a constant term, and \code{coeff[2]} is a coefficient of 1st degree
term, etc. Evaluation is done using Horner's method.
}
\examples{
## Evaluate a polynomial x^2 - 2x + 2 with x = 1, 2, 3.
## 0th, 1st, 2nd degree of coefficients
coeff <- c(2, -2, 1)
x <- c(1, 2, 3)
eval_poly(coeff, x)
}
\seealso{
\code{\link[=pdf_gaussmodel]{pdf_gaussmodel()}} \code{\link[=pdf_expmodel]{pdf_expmodel()}} \code{\link[=cdf_gaussmodel]{cdf_gaussmodel()}}
\code{\link[=cdf_expmodel]{cdf_expmodel()}}
}
