% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logodds_fn.R
\name{eif_pmf_k}
\alias{eif_pmf_k}
\title{Get EIF estimates for treatment-specific PMF at a particular
level of the outcome}
\usage{
eif_pmf_k(k, out, treat, trt_level, trt_spec_prob_est, trt_k_spec_pmf_est)
}
\arguments{
\item{k}{The level of the outcome.}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{treat}{A \code{numeric} vector containing treatment status. Should only assume 
a value 0 or 1.}

\item{trt_level}{Treatment level}

\item{trt_spec_prob_est}{Estimated propensity for \code{trt_level}.}

\item{trt_k_spec_pmf_est}{Estimated conditional PMF for \code{trt_level} at \code{k}.}
}
\description{
Get EIF estimates for treatment-specific PMF at a particular
level of the outcome
}
