% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_stats.R
\name{compute_stats}
\alias{compute_stats}
\title{Compute Dropout Statistics}
\usage{
compute_stats(df, by_cond = "None", no_of_vars)
}
\arguments{
\item{df}{data.frame containing variable \code{do_idx} from \code{\link[=add_dropout_idx]{add_dropout_idx()}}}

\item{by_cond}{character name of condition variable in the data, defaults to 'None' to output total statistics.}

\item{no_of_vars}{numeric number of variables that contain questions}
}
\value{
A data frame with 6 columns (q_idx, condition, cs, N, remain, pct_remain)
and as many rows as questions in original data (for overall data and if conditions selected
again for each condition).
}
\description{
This is the \emph{second step} in conducting dropout analysis with \code{dropR}.
Outputs all necessary statistics to analyze and visualize dropout, such as
the sample size N of the data (and in each condition if selected), cumulative
dropout and remaining participants in absolute numbers and percent.
If no experimental condition is added, the stats are only calculated for the
whole data in total.
}
\examples{
do_stats <- compute_stats(df = add_dropout_idx(dropRdemo, 3:54),
by_cond = "experimental_condition",
no_of_vars = 52)
  
}
