% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawBox}
\alias{drawBox}
\title{Draw a Box on the Page}
\usage{
drawBox(x, y, width = .pkgenv$boxWidth, height = .pkgenv$boxHeight,
  radius = .pkgenv$boxRadius, fillColor = .pkgenv$boxFillColor,
  opacity = .pkgenv$boxOpacity, lineColor = .pkgenv$boxLineColor,
  lineWidth = .pkgenv$boxLineWidth, lineType = .pkgenv$boxLineType,
  units = .pkgenv$units, ...)
}
\arguments{
\item{x}{Numeric value for the x-axis position of the center.}

\item{y}{Numeric value for the y-axis position of the center.}

\item{width}{Numeric value for the width.}

\item{height}{Numeric value for the height.}

\item{radius}{Numeric value for the radius to create rounded box corners.}

\item{fillColor}{Character value for the fill color.}

\item{opacity}{Numeric value for the transparency with values ranging from 0 (transparent) to 1 (non-transparent).}

\item{lineColor}{Character value for the color of the lines.}

\item{lineWidth}{Numeric value for the width of the lines.}

\item{lineType}{Character value for the line type. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).}

\item{units}{Character value for the \link[grid]{unit} to use when specifying measurements.}

\item{...}{Additional arguments passed to \link[grid]{grid.rect}.}
}
\value{
A \link[grid]{grid.rect} \link[grid]{grob} object.
}
\description{
Draws a box on the page given positioning, dimensions and styling.
\cr\cr
\if{html}{\figure{drawbox.png}{options: width=250 alt="Figure: drawBox Example"}}
\if{latex}{\figure{drawbox.png}{options: width=3in alt="Figure: drawBox Example"}}
}
\examples{
library(draw)

# Set drawing settings
drawSettings(pageWidth = 5, pageHeight = 5, units = "inches")

# Create a new drawing page
drawPage()

# Draw a square
drawBox(x = 1, y = 4, width = 1, height = 1)

# Draw a square with rounded corners
drawBox(x = 4, y = 4, width = 1, height = 1, radius = 0.25)

# Draw a rectangle
drawBox(x = 1, y = 1, width = 1, height = 0.5)

# Draw a rectangle with rounded corners
drawBox(x = 4, y = 1, width = 1, height = 0.5, radius = 0.25)

# Export the drawing page to a PDF
drawExport("drawBox.pdf")

}
\seealso{
\link{drawSettings}
}
