% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpm.R
\name{summary,dpm-method}
\alias{summary,dpm-method}
\title{Summarize dpm objects}
\usage{
\S4method{summary}{dpm}(
  object,
  standardized = FALSE,
  ci = FALSE,
  se = TRUE,
  zstat = TRUE,
  pvalue = TRUE,
  ci.level = 0.95,
  boot.ci.type = c("perc", "norm", "basic", "bca.simple"),
  digits = getOption("dpm-digits", 3),
  ...
)
}
\arguments{
\item{object}{A \code{dpm} object.}

\item{standardized}{Use \code{lavaan}'s method for standardizing coefficients?
Default is FALSE.}

\item{ci}{Show confidence intervals? Default is FALSE.}

\item{se}{Show standard errors? Default is TRUE.}

\item{zstat}{Show the z statistic? Default is TRUE.}

\item{pvalue}{Show p values? Default is TRUE.}

\item{ci.level}{How wide should the confidence intervals be? Ignored if
\code{ci} is FALSE. Default is .95.}

\item{boot.ci.type}{If the model was fit with bootstrapped standard errors
and \code{ci} is TRUE, which method should be used for finding the intervals?
Default is \code{"perc"}.}

\item{digits}{How many digits should be printed in the model summary?
Default is 3. You can set a default by setting the option \code{"dpm-digits"}.}

\item{...}{Ignored.}
}
\value{
Returns a \code{summary.dpm} object, which is a list with three elements:
\itemize{
\item \code{model}: The \code{dpm} object.
\item \code{coefficients}: A data frame containing coefficient estimates,
standard errors, p values, and so on.
\item \code{fitmeasures}: A numeric vector containing model fit information.
}

The primary function of the object is to be printed to the console.
}
\description{
The summary method is designed to offer similar arguments to
\code{lavaan}'s summary, but with shorter and more domain-specific output.
}
