% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_run.R
\name{extract_run}
\alias{extract_run}
\title{Extract Digital PCR Run}
\usage{
extract_run(input, id)
}
\arguments{
\item{input}{object of the class \code{\linkS4class{adpcr}} or
\code{\linkS4class{dpcr}}.}

\item{id}{vector of indices or names of runs.}
}
\value{
The object of the input's class (\code{\linkS4class{adpcr}} or
\code{\linkS4class{dpcr}}).
}
\description{
Extract runs from a \code{\linkS4class{dpcr}} object while preserving all other
attributes.
}
\details{
The \code{extract_run} function allows to choose one or more panels from an
object of the \code{\linkS4class{adpcr}} or \code{\linkS4class{dpcr}} class
and save it without changing other attributes. It is the most recommended
method of extracting a subset from an array of panels, because it preserves
class and structure of the object in contrary to standard operator
\link[base]{Extract}.
}
\note{
The standard \code{\link[base]{Extract}} operator \code{x[i]} treats
dpcr objects as \code{matrix} and extracts values without preserving other
attributies of the object.
}
\examples{

#sample extracting
panels <- sim_adpcr(10, 40, 1000, pos_sums = FALSE, n_panels = 50)
single_panel <- extract_run(panels, 5)
random_three <- extract_run(panels, sample.int(ncol(panels), 3))
all_but_one <- extract_run(panels, -5)

#the same for fluorescence data
fluos <- sim_dpcr(10, 40, 1000, pos_sums = FALSE, n_exp = 50, 
                   fluo = list(0.1, 0))
single_fluo <- extract_run(fluos, 5)


}
\seealso{
Opposite function: \code{\link{bind_dpcr}}
Extract multiple runs belonging to an experiment of assay: 
\code{\link{extract_dpcr}}
}
\author{
Michal Burdukiewicz.
}
\keyword{extract}
\keyword{manip}
\keyword{panel}
