% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{covar.logrr}
\alias{covar.logrr}
\title{Computes the covariance matrix for a set of log relative risks}
\usage{
covar.logrr(cases, n, y, v, type, data, covariance = "gl")
}
\arguments{
\item{cases}{a vector, defining the number of cases for each exposure level.}

\item{n}{a vector, defining the total number of subjects for each exposure level. For incidence-rate data \code{n} indicates the amount of person-time within 
each exposure level.}

\item{y}{a vector, defining the (reported) log relative risks.}

\item{v}{a vector, defining the variances of the reported log relative risks.}

\item{type}{a vector (or a character string), specifying the design of the study. Options are
\code{cc}, \code{ir}, and \code{ci}, for case-control, incidence-rate, and cumulative incidence data, respectively.}

\item{data}{an optional data frame (or object coercible by \code{\link{as.data.frame}} to a data frame) containing the variables in the previous arguments.}

\item{covariance}{method to approximate the coviariance among set of reported log relative risks, "\code{gl}" for the method proposed by Greenland and Longnecker
(default), "\code{h}" for the method proposed by Hamling.}
}
\value{
The (co)variance matrix of the log relative risks.
}
\description{
Reconstructs the covariance matrix for a set of (reported) log relative risks, given the number of cases and 
the number of total persons or person-years for each treatment (dose) level.
}
\details{
This is an internal function called by \code{\link{dosresmeta}} to reconstruct the (co)variance matrix of the (adjusted) log relative risks. The function
calls, depending on the choosen method, \code{\link{grl}} (default) or \code{\link{hamling}} to reconstruct the effective counts corresponding to the (adjusted) log
relative risks as well as their standard errors. From these it computes the covariance matrix; analytical formulas can be found in the referenced article.
}
\examples{
## Loading data
data("alcohol_cvd")

## Obtaining the (co)variance matrix of log RR for the first study (id = 1)
covar.logrr(y = logrr, v = I(se^2), cases = cases, n = n, type = type, 
            data = subset(alcohol_cvd, id == 1))

## Obtaining the (co)variance matrices of log RRfor all study
by(alcohol_cvd, alcohol_cvd$id, function(x)
   covar.logrr(y = logrr, v = I(se^2), cases = cases, n = n, 
               type = type, data = x))

## Restructuring the previous results in a list of matrices
do.call("list", by(alcohol_cvd, alcohol_cvd$id, function(x)
   covar.logrr(y = logrr, v = I(se^2), cases = cases, n = n, type = type,
               data = x)))

}
\references{
Orsini, N., Li, R., Wolk, A., Khudyakov, P., Spiegelman, D. (2012). Meta-analysis for linear and nonlinear dose-response relations: 
examples, an evaluation of approximations, and software. American journal of epidemiology, 175(1), 66-73.
}
\seealso{
\code{\link{grl}}, \code{\link{hamling}}, \code{\link{covar.smd}}, \code{\link{dosresmeta}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
