% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_snapshot_doc.R
\name{expect_snapshot_html}
\alias{expect_snapshot_html}
\title{Visual test for an HTML document}
\usage{
expect_snapshot_html(
  name,
  x,
  tolerance = 0.001,
  engine = c("tinytest", "testthat"),
  ...
)
}
\arguments{
\item{name}{a string to identify the test. Each document in the test suite must have a unique name.}

\item{x}{file path of an HTML document}

\item{tolerance}{the ratio of different pixels that is acceptable before triggering a failure.}

\item{engine}{test package being used in the test suite, one of "tinytest" or "testthat".}

\item{...}{arguments used by \code{webshot::webshot2()}.}
}
\value{
A \code{\link[tinytest:tinytest]{tinytest::tinytest()}} or a \link[testthat:expect_snapshot_file]{testthat::expect_snapshot_file} object.
}
\description{
This expectation can be used with 'tinytest' and 'testthat'
to check if a current document of type HTML
matches a target document. When the expectation is checked
for the first time, the expectation fails and a target miniature
of the document is saved in a folder named \verb{_tinytest_doconv} or
\verb{_snaps}.
}
\examples{
file <- tempfile(fileext = ".html")
html <- paste0("<html><head><title>hello</title></head>",
       "<body><h1>Hello World</h1></body></html>\n")
cat(html, file = file)

\dontrun{
if (require("tinytest") && require("webshot2")){
  # first run add a new snapshot
  expect_snapshot_html(x = file, name = "html file",
    engine = "tinytest")
  # next runs compare with the snapshot
  expect_snapshot_html(x = file, name = "html file",
    engine = "tinytest")

  # cleaning directory
  unlink("_tinytest_doconv", recursive = TRUE,
    force = TRUE)
}
if (require("testthat") && require("webshot2")){
  local_edition(3)
  # first run add a new snapshot
  expect_snapshot_html(x = file, name = "html file",
    engine = "testthat")
  # next runs compare with the snapshot
  expect_snapshot_html(x = file, name = "html file",
    engine = "testthat")
}
}
}
