% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshapeData.R
\name{reshapeData}
\alias{reshapeData}
\title{Reshape Barcode Abundance Data to Frequency Format}
\usage{
reshapeData(input_data)
}
\arguments{
\item{input_data}{A data frame with exactly three columns: \code{ID} (character or factor),
\code{Time} (numeric), and \code{Reads} (numeric). Each row corresponds to a measurement for one barcode at one time point.}
}
\value{
A tidy data frame with columns: \code{ID}, \code{max}, \code{start}, \code{final}, \code{mean}, \code{Time}, and \code{Frequency}.
Frequencies are normalized across all barcodes per time point. The result is ordered by decreasing \code{max} frequency.
}
\description{
Transforms raw barcode abundance data into a tidy long-format data frame, computing summary statistics
for each barcode (ID), including maximum, initial, final, and average frequencies across time points.
}
\details{
This function expects a data frame with three columns: \code{ID}, \code{Time}, and \code{Reads}.
Frequencies are computed by normalizing the \code{Reads} across all barcodes for each time point.
}
\examples{
# Load demo barcode count data (installed with the package)
demo_file <- system.file("extdata", "demo_input.csv", package = "doblin")
input_dataframe <- readr::read_csv(demo_file, show_col_types = FALSE)

# Reshape data to long-format with normalized frequencies +
# sort data by descending maximum frequency
reshaped_df <- reshapeData(input_dataframe)
}
