% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{plot_hist_numeric}
\alias{plot_hist_numeric}
\alias{plot_hist_numeric.data.frame}
\alias{plot_hist_numeric.grouped_df}
\title{Plot histogram of numerical variables}
\usage{
plot_hist_numeric(.data, ...)

\method{plot_hist_numeric}{data.frame}(
  .data,
  ...,
  title = "Distribution by numerical variables",
  each = FALSE,
  typographic = TRUE,
  base_family = NULL
)

\method{plot_hist_numeric}{grouped_df}(
  .data,
  ...,
  title = "Distribution by numerical variables",
  each = FALSE,
  typographic = TRUE,
  base_family = NULL
)
}
\arguments{
\item{.data}{data.frame or a \code{\link[tibble]{tbl_df}} or a \code{\link[dplyr]{grouped_df}}.}

\item{\dots}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_hist_numeric() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where
column names represent column positions.
They support unquoting and splicing.}

\item{title}{character. a main title for the plot.}

\item{each}{logical. Specifies whether to draw multiple plots on one screen. 
The default is FALSE, which draws multiple plots on one screen.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\description{
The plot_hist_numeric() to visualizes the histogram of numeric data or 
relationship to specific categorical data.
}
\details{
The histogram helps determine whether the distribution of a numeric variable. 
plot_hist_numeric() shows box plots of several numeric variables 
on one screen. This function can also display a histogram for each level of a specific 
categorical variable.
The bin-width is set to the Freedman-Diaconis rule (2 * IQR(x) / length(x)^(1/3))

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
\donttest{
# Visualization of all numerical variables
plot_hist_numeric(heartfailure)

# Select the variable to diagnose
plot_hist_numeric(heartfailure, "age", "time")
plot_hist_numeric(heartfailure, -age, -time)

# Visualize the each plots
plot_hist_numeric(heartfailure, "age", "time", each = TRUE)

# Not allow the typographic elements
plot_hist_numeric(heartfailure, typographic = FALSE)

# Using pipes ---------------------------------
library(dplyr)

# Plot of all numerical variables
heartfailure \%>\%
  plot_hist_numeric()
  
# Using groupd_df  ------------------------------
heartfailure \%>\% 
  group_by(smoking) \%>\% 
  plot_hist_numeric()
  
heartfailure \%>\% 
  group_by(smoking) \%>\% 
  plot_hist_numeric(each = TRUE)  
}
   
}
