% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pdlm.R
\name{plot.pdlm}
\alias{plot.pdlm}
\title{Plot a Fitted Predictive Dynamic Linear Model}
\usage{
\method{plot}{pdlm}(x, plot_data = TRUE, conf.int = FALSE, sig.level = 0.95, ...)
}
\arguments{
\item{x}{An object of class \code{pdlm}, as returned by \code{\link[dlm]{dlm}}.}

\item{plot_data}{Logical; if \code{TRUE} (default) the observed data points are plotted.}

\item{conf.int}{Logical; if \code{TRUE}, plot confidence intervals with the given sig.level.}

\item{sig.level}{Numeric; significance level for confidence intervals (default: 0.95).}

\item{...}{Additional graphical parameters to pass to the underlying plotting functions.}
}
\value{
This function produces a plot of the fitted DLM and returns \code{NULL} invisibly.
}
\description{
Produces a plot for an object of class \code{pdlm} (typically created by \code{pdlm}).
The function displays the observed data along with the fitted curves computed using filtered and/or
smoothed state estimates.
}
