% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits.R
\name{spat.trait}
\alias{spat.trait}
\title{Average trait calculation for raster}
\usage{
spat.trait(x, trait, cores = 1, filename = "", ...)
}
\arguments{
\item{x}{A SpatRaster with presence-absence data (0 or 1) for a
set of species.}

\item{trait}{A 'data.frame' with species traits. Rownames must
have species names that match with 'x'!}

\item{cores}{A positive integer. If cores > 1, a 'parallel'
package cluster with that many cores is created and used.}

\item{filename}{Character. Save results if a name is provided.}

\item{...}{Additional arguments to be passed passed down from a
calling function.}
}
\value{
SpatRaster with average traits.
}
\description{
Compute average for each trait.
}
\examples{
\donttest{
library(terra)
bin1 <- terra::rast(system.file("extdata", "ref.tif",
package = "divraster"))
traits <- read.csv(system.file("extdata", "traits.csv",
package = "divraster"), row.names = 1)
spat.trait(bin1, traits)
}
}
