% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull.R
\name{weibull}
\alias{weibull}
\alias{mweibull}
\title{The Weibull distribution}
\usage{
mweibull(r = 0, truncation = 0, shape = 2, scale = 1, lower.tail = TRUE)
}
\arguments{
\item{r}{rth raw moment of the distribution, defaults to 1.}

\item{truncation}{lower truncation parameter, defaults to 0.}

\item{shape, scale}{shape and scale of the distribution with default values of 2 and 1 respectively.}

\item{lower.tail}{logical; if TRUE (default), moments are \eqn{E[x^r|X \le y]}, otherwise, \eqn{E[x^r|X > y]}}
}
\value{
returns the truncated rth raw moment of the distribution.
}
\description{
Raw moments for the Weibull distribution.
}
\details{
Probability and Cumulative Distribution Function:

 \deqn{f(x) = \frac{shape}{scale}(\frac{\omega}{scale})^{shape-1}e^{-(\frac{\omega}{scale})^shape} , \qquad F_X(x) = 1-e^{-(\frac{\omega}{scale})^shape}}

 The y-bounded r-th raw moment of the distribution equals:

 \deqn{\mu^r_y =   scale^{r} \Gamma(\frac{r}{shape} +1, (\frac{y}{scale})^shape ) }

 where \eqn{\Gamma(,)} denotes the upper incomplete gamma function.
}
\examples{

## The zeroth truncated moment is equivalent to the probability function
pweibull(2, shape = 2, scale = 1)
mweibull(truncation = 2)

## The (truncated) first moment is equivalent to the mean of a (truncated) random sample,
#for large enough samples.
x <- rweibull(1e5, shape = 2, scale = 1)
mean(x)
mweibull(r = 1, lower.tail = FALSE)

sum(x[x > quantile(x, 0.1)]) / length(x)
mweibull(r = 1, truncation = quantile(x, 0.1), lower.tail = FALSE)
}
