% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invpareto.R
\name{invpareto_plt}
\alias{invpareto_plt}
\title{Inverse Pareto coefficients after power-law transformation}
\usage{
invpareto_plt(xmax = 5, k = 1.5, a = 1, b = 1, inv = FALSE)
}
\arguments{
\item{xmax, k}{Scale and shape of the Inverse Pareto distribution, defaults to 5 and 1.5 respectively.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}

 ## Comparing probabilites of power-law transformed transformed variables
 pinvpareto(3,k=2,xmax=5)
 coeff = invpareto_plt(xmax=5,k=2,a=5,b=7)$coefficients
 pinvpareto(5*3^7,k=coeff[["k"]],xmax=coeff[["xmax"]])

 pinvpareto(5*0.9^7,k=2,xmax=5)
 coeff = invpareto_plt(xmax=5,k=2,a=5,b=7, inv=TRUE)$coefficients
 pinvpareto(0.9,k=coeff[["k"]],xmax=coeff[["xmax"]])
}
\description{
Coefficients of a power-law transformed Inverse Pareto distribution
}
\details{
If the random variable x is Inverse Pareto-distributed with scale xmin and shape k, then the power-law transformed variable

 \deqn{ y = ax^b }

 is Inverse Pareto distributed with scale \eqn{ ( \frac{xmin}{a})^{\frac{1}{b}} } and shape \eqn{b*k}.
}
