% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_return.R
\name{eval_return}
\alias{eval_return}
\alias{enframe_return}
\title{Return Level Function}
\usage{
eval_return(distribution, at)

enframe_return(..., at, arg_name = ".arg", fn_prefix = "return", sep = "_")
}
\arguments{
\item{distribution, ...}{A distribution, or possibly multiple
distributions in the case of \code{...}.}

\item{at}{Vector of return periods >=1.}

\item{arg_name}{For \code{enframe_}, name of the column containing
the function arguments. Length 1 character vector.}

\item{fn_prefix}{For \code{enframe_}, name of the function to
appear in the column(s). Length 1 character vector.}

\item{sep}{When \code{enframe}'ing more than one distribution, the
character that will be separating the \code{fn_name} and the distribution name.
Length 1 character vector.}
}
\value{
The evaluated representation in vector form (for \code{eval_})
with length matching the length of \code{at}, and data frame
or tibble form (for \code{enframe_}) with number of rows matching the
length of \code{at}. The \code{at} input occupies the first column,
named \code{.arg} by default, or the specification in \code{arg_name};
the evaluated representations for each distribution in \code{...}
go in the subsequent columns (one column per distribution). For a
single distribution, this column is named according to the
representation by default (cdf, survival, quantile, etc.),
or the value in \code{fn_prefix}. For multiple distributions, unnamed
distributions are auto-named, and columns are named
\verb{<fn_prefix><sep><distribution_name>} (e.g., \code{cdf_distribution1}).
}
\description{
Compute return levels (quantiles) from a distribution by inputting
return periods. The return periods correspond to events that are
\emph{exceedances} of a quantile, not non-exceedances.
}
\details{
This function is simply the quantile
function evaluated at \code{1 - 1 / at}.
}
\examples{
d <- dst_gp(24, 0.3)
eval_return(d, at = c(2, 25, 100, 200))
}
\seealso{
Other distributional representations: 
\code{\link{eval_cdf}()},
\code{\link{eval_chf}()},
\code{\link{eval_density}()},
\code{\link{eval_hazard}()},
\code{\link{eval_odds}()},
\code{\link{eval_pmf}()},
\code{\link{eval_quantile}()},
\code{\link{eval_survival}()}
}
\concept{distributional representations}
