% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dst}
\alias{plot.dst}
\title{Plot a Distribution}
\usage{
\method{plot}{dst}(
  x,
  what = c("density", "pmf", "cdf", "survival", "quantile", "hazard", "chf"),
  ...
)
}
\arguments{
\item{x}{Distribution object}

\item{what}{Name of the representation to plot.}

\item{...}{Other arguments to pass to the \code{graphics::curve} function,
or \code{graphics::plot} in the case of the PMF.}
}
\value{
This function is run for its graphics byproduct, and therefore
returns the original distribution, invisibly.
}
\description{
Plot a distribution's representation.
}
\examples{
d <- dst_norm(0, 1)
plot(d, from = -4, to = 4)
plot(d, "cdf", n = 1000)
plot(d, "survival")
plot(d, "quantile")
plot(d, "hazard")
plot(d, "chf")

p <- dst_pois(4)
plot(p)
}
