% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdq_gp.R
\name{pgp}
\alias{pgp}
\alias{qgp}
\alias{dgp}
\title{Representations of the Generalized Pareto Distribution}
\usage{
pgp(q, scale, shape, lower.tail = TRUE)

qgp(p, scale, shape)

dgp(x, scale, shape)
}
\arguments{
\item{scale}{Vector of scale parameters; positive numeric.}

\item{shape}{Vector of shape parameters; positive numeric.}

\item{lower.tail}{Single logical. If \code{TRUE}, cdf (default);
if \code{FALSE}, survival function.}

\item{p}{Vector of probabilities.}

\item{x, q}{Vector of quantiles.}
}
\value{
Vector of evaluated GP distribution, with length
equal to the recycled lengths of \code{q}/\code{x}/\code{p}, \code{scale}, and \code{shape}.
}
\description{
Representations of the Generalized Pareto Distribution
}
\examples{
pgp(1:10, 1, 1)
dgp(1:10, 2, 0)
qgp(1:9 / 10, 10, -2)
}
