% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diario.R
\name{diario_perform_request}
\alias{diario_perform_request}
\title{Perform an API request to Diario}
\usage{
diario_perform_request(
  endpoint,
  query = list(),
  method = "GET",
  body = NULL,
  verbosity = 0
)
}
\arguments{
\item{endpoint}{A non-empty character string specifying the API endpoint.}

\item{query}{A named list of query parameters (optional).}

\item{method}{The HTTP method to use (e.g., "GET", "POST", "PUT", "DELETE"). Default is "GET".}

\item{body}{A list representing the JSON body for request methods that support a body (e.g., POST).}

\item{verbosity}{Verbosity level for the request (0 = none, 1 = minimal). Default is 0.}
}
\value{
A list (by default) containing the response from the API. If the content is JSON,
it will be returned as an R object. If not, an error is raised.
}
\description{
This function performs an authenticated request to the specified endpoint of the Diario API.
}
\examples{
\dontrun{
diario_perform_request("v1/obras", query = list(status = "active"))
}
}
