% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwd_regL1_methods.R
\name{plot.forwardSearch_regL1}
\alias{plot.forwardSearch_regL1}
\title{Forward Search in Linear L1 Models}
\usage{
\method{plot}{forwardSearch_regL1}(
  x,
  type.plot = 1:5,
  squared = FALSE,
  scaled = FALSE,
  ylim = NULL,
  xlim = NULL,
  th.Res = 2,
  th.Lev = 0.25,
  sig.Tst = 2.58,
  labels.in.plot = TRUE,
  ...
)
}
\arguments{
\item{x}{a "forwardSearch_regL1" object.}

\item{type.plot}{select which plots to draw, by default all. Each graph is addressed by an integer:
\enumerate{
\item scaled residuals
\item minimum deletion residuals
\item coefficients
\item statistics
\item MAE (Mean Absolute Error) values
}}

\item{squared}{logical, if TRUE plots squared residuals.}

\item{scaled}{logical, if TRUE plots scaled coefficient estimates.}

\item{ylim}{a two component vector for the min and max of the y axis.}

\item{xlim}{a two component vector for the min and max of the x axis.}

\item{th.Res}{numerical, a threshold for labelling the residuals.}

\item{th.Lev}{numerical, a threshold for labelling the leverages.}

\item{sig.Tst}{numerical, a value (on the scale of the t statistics) used to draw the confidence interval on the plot of the t statistics.}

\item{labels.in.plot}{logical, if TRUE units are labelled in the plots when required.}

\item{...}{additional arguments.}
}
\value{
No return value, just plots the results of a forward search in linear L1 models.
}
\description{
This function plots the results of a forward search in linear L1 models.
}
\examples{
\donttest{

# applies the forward search approach to robust analysis in a linear L1 model
mod = forwardSearch_regL1(Concentration ~ Age, data = bile)
plot(mod, 1)
}
}
\seealso{
\code{\link[diagL1]{forwardSearch_regL1}} for apply forward search in linear L1 regression model.
}
