\docType{data}

\name{data.income}

\alias{data.income}

\title{Income Per Capita}

\format{
A data frame with 75 observations on the following three variables:
\tabular{ll}{
\code{loginc} \tab logarithmic per capita income.\cr
\code{logsave} \tab logarithmic savings rate.\cr
\code{logsum} \tab logarithmic sum of population growth rate, technical progress and capital depreciation.\cr
}
}

\source{
Mankiw, N.G., Romer, D. & Weil, D.N. (1992): A Contribution to the Empirics of Economic Growth. Quarterly Journal of Economics, 107, 407-437

Summers, R., Heston, A. (1988): A new set of International Comparisons of Real Product and Price Levels Estimates for 130 Countries, 1950–1985, Review of Income and Wealth, 34(1), 1-25
}

\usage{
data.income
}

\description{
This data set describes major macroeconomic variables determining the differences in per capita income of 75 countries in 1985.
}

\details{
In Auer (2023, Chap. 19) and Auer et al. (2024, Chap. 19) these data are used to illustrate the detection and consequences of error terms that are not normally distributed.
}

\references{
Auer, L.v. (2023): Ökonometrie - Eine Einführung, 8th ed., Springer-Gabler (\href{https://www.uni-trier.de/index.php?id=15929}{https://www.oekonometrie-lernen.de}).

Auer, L.v., Hoffmann, S. & Kranz, T. (2024): Ökonometrie - Das R-Arbeitsbuch, 2nd ed., Springer-Gabler (\href{https://www.uni-trier.de/index.php?id=15929}{https://www.oekonometrie-lernen.de}).
}

\keyword{datasets}
