% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{optimize_design}
\alias{optimize_design}
\title{Generic optimizer that can be customized by user provided functions for generating shuffles and progressing towards the minimal score}
\usage{
optimize_design(
  batch_container,
  samples = NULL,
  scoring = NULL,
  n_shuffle = NULL,
  shuffle_proposal_func = NULL,
  acceptance_func = accept_strict_improvement,
  aggregate_scores_func = identity,
  check_score_variance = TRUE,
  autoscale_scores = FALSE,
  autoscaling_permutations = 100,
  autoscale_useboxcox = TRUE,
  sample_attributes_fixed = FALSE,
  max_iter = 10000,
  min_delta = NA,
  quiet = FALSE
)
}
\arguments{
\item{batch_container}{An instance of \code{BatchContainer}.}

\item{samples}{A \code{data.frame} with sample information.
Should be \code{NULL} if the \code{BatchContainer} already has samples in it.}

\item{scoring}{Scoring function or a named \code{\link[=list]{list()}} of scoring functions.}

\item{n_shuffle}{Vector of length 1 or larger, defining how many random sample
swaps should be performed in each iteration. If \code{length(n_shuffle)==1},
this sets no limit to the number of iterations. Otherwise, the optimization
stops if the swapping protocol is exhausted.}

\item{shuffle_proposal_func}{A user defined function to propose the next shuffling of samples.
Takes priority over n_shuffle if both are provided. The function is called with
a \link{BatchContainer} \code{bc} and an integer parameter \code{iteration} for the current iteration number,
allowing very flexible shuffling strategies.
Mapper syntax is supported (see \code{\link[purrr:as_mapper]{purrr::as_mapper()}}).
The returned function must either return a list with fields \code{src}and \code{dst} (for pairwise sample swapping)
or a numeric vector with a complete re-assigned sample order.}

\item{acceptance_func}{Alternative function to select a new score as the best one.
Defaults to strict improvement rule, i.e. all elements of a score have to be smaller or equal in order to accept the solution as better.
This may be replaced with an alternative acceptance function included in the package
(e.g. \code{\link[=mk_simanneal_acceptance_func]{mk_simanneal_acceptance_func()}}) or a user provided function.
Mapper syntax is supported (see \code{\link[purrr:as_mapper]{purrr::as_mapper()}}).}

\item{aggregate_scores_func}{A function to aggregate multiple scores AFTER (potential) auto-scaling and BEFORE acceptance evaluation.
If a function is passed, (multi-dimensional) scores will be transformed (often to a single double value) before calling the acceptance function.
E.g., see \code{\link[=first_score_only]{first_score_only()}} or \code{\link[=worst_score]{worst_score()}}.
Note that particular acceptance functions may require aggregation of a score to a single scalar in order to work, see for example those
generated by \code{\link[=mk_simanneal_acceptance_func]{mk_simanneal_acceptance_func()}}.
Mapper syntax is supported (see \code{\link[purrr:as_mapper]{purrr::as_mapper()}}).}

\item{check_score_variance}{Logical: if TRUE, scores will be checked for variability under sample permutation
and the optimization is not performed if at least one subscore appears to have a zero variance.}

\item{autoscale_scores}{Logical: if TRUE, perform a transformation on the fly to equally scale scores
to a standard normal. This makes scores more directly comparable and easier to aggregate.}

\item{autoscaling_permutations}{How many random sample permutations should be done to estimate autoscaling parameters.
(Note: minimum will be 20, regardless of the specified value)}

\item{autoscale_useboxcox}{Logical; if TRUE, use a boxcox transformation for the autoscaling if possible at all.
Requires installation of the \code{bestNormalize} package.}

\item{sample_attributes_fixed}{Logical; if TRUE, sample shuffle function may generate altered sample attributes at each iteration.
This affects estimation of score distributions. (Parameter only relevant if shuffle function does introduce attributes!)}

\item{max_iter}{Stop optimization after a maximum number of iterations,
independent from other stopping criteria (user defined shuffle proposal or min_delta).}

\item{min_delta}{If not NA, optimization is stopped as soon as successive improvement (i.e. euclidean distance between score vectors
from current best and previously best solution) drops below min_delta.}

\item{quiet}{If TRUE, suppress non-critical warnings or messages.}
}
\value{
A trace object
}
\description{
Generic optimizer that can be customized by user provided functions for generating shuffles and progressing towards the minimal score
}
\examples{
data("invivo_study_samples")
bc <- BatchContainer$new(
  dimensions = c("plate" = 2, "column" = 5, "row" = 6)
)
bc <- optimize_design(bc, invivo_study_samples,
  scoring = osat_score_generator("plate", "Sex"),
  max_iter = 100
)
plot_plate(bc$get_samples(), .col = Sex)
}
