% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asiangeomavg.R
\name{asiangeomavg}
\alias{asiangeomavg}
\alias{geomavgprice}
\alias{geomavgpricecall}
\alias{geomavgpriceput}
\alias{geomavgstrike}
\alias{geomavgstrikecall}
\alias{geomavgstrikeput}
\title{Geometric average asian options}
\usage{
geomavgprice(s, k, v, r, tt, d, m, cont=FALSE)
geomavgpricecall(s, k, v, r, tt, d, m, cont=FALSE)
geomavgpriceput(s, k, v, r, tt, d, m, cont=FALSE)
geomavgstrike(s, km, v, r, tt, d, m, cont=FALSE)
geomavgstrikecall(s, km, v, r, tt, d, m, cont=FALSE)
geomavgstrikeput(s, km, v, r, tt, d, m, cont=FALSE)
}
\arguments{
\item{s}{Price of underlying asset}

\item{k}{Strike price of the option. In the case of average strike
options, \code{k/s} is the multiplier for the average}

\item{v}{Volatility of the underlygin asset price, defined as the
annualized standard deviation of the continuously-compounded
return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{m}{Number of prices in the average calculation}

\item{cont}{Boolean which when TRUE denotes continuous averaging}

\item{km}{The strike mutiplier, relative to the initial stock
price, for an average price payoff. If the initial stock price
is \code{s = 120} and \code{km = 115}, the payoff for an
average strike call is \deqn{Payoff = max(ST - km/s*SAvg, 0)}.}
}
\value{
Option prices as a vector
}
\description{
Pricing functions for European Asian options based on
    geometric averages. \code{geomavgpricecall},
    \code{geomavgpriceput}, \code{geomavgstrikecall} and
    \code{geomavgstrikeput} compute analytical prices of geometric
    Asian options using the modified Black-Scholes formula.
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0; m=3;
geomavgpricecall(s, k, v, r, tt, d, m)
geomavgpricecall(s, 38:42, v, r, tt, d, m)
geomavgpricecall(s, 38:42, v, r, tt, d, m, cont=TRUE)

}
\seealso{
Other Asian: 
\code{\link{arithasianmc}()},
\code{\link{arithavgpricecv}()},
\code{\link{geomasianmc}()}
}
\concept{Asian}
