% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{basal}
\alias{basal}
\title{The basal area of plots}
\usage{
basal(dbh, area, k = 100, circum = NULL)
}
\arguments{
\item{dbh}{numeric, vector of diameter.}

\item{area}{numeric, area of the plot (see \code{details} for unit).}

\item{k}{numeric, used to convert diameter unit. Default is \code{100}
(coverts from cm to m. See \code{details}).}

\item{circum}{numeric, vector of circumference. Is used only if \code{dbh}
is not given.}
}
\value{
A vector of basal area of stands.
}
\description{
Computes the basal area of tree stems in a plot. The basal area
is the cross sectional area of the bole or stem of a tree at breast height.
}
\details{
If \code{area} is expressed in ha and \code{dbh} expressed in cm,
the basal area unit is cm\\u00b2/ha when \code{k = 1}.
In order to convert centimeter (cm) to meter (m) for \code{dbh}, set
\code{k = 100}. Because 1m = 100 cm. Then, basal area unit will be
\code{m\\u00b2/ha}.

If \code{dbh} is in meter (m), and \code{area} in in hectare (ha), setting
\code{k = 1} returns basal area in m\\u00b2/ha.

If \code{dbh} is in feet, and \code{area} in acre, setting \code{k = 1}
 returns basal area in ft\\u00b2/ac.

If \code{dbh} is in inch, and \code{area} in acre, setting
\code{k = 12} returns basal area in feet\\u00b2/acres (ft\\u00b2/ac).
}
