% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ZG_output.R
\name{plot_ZG_output}
\alias{plot_ZG_output}
\title{Plotting output of zero-growth approach (i.e., output of phase.zg function).}
\usage{
plot_ZG_output(ZG_output, DOY, Year)
}
\arguments{
\item{ZG_output}{list the output of \code{phase.zg} function.}

\item{DOY}{array with initial and final day for plotting. E.g. \emph{c(a,b)}, where a = initial date and b = final date.}

\item{Year}{array for indicating year for plotting.}
}
\value{
A plot with GRO and TWD in two different subplots.
}
\description{
This function plots the GRO and TWD of dendrometer data for a defined time period.
}
\examples{
\donttest{
library(dendRoAnalyst)
data(gf_nepa17)
zg.phase<-phase.zg(df=gf_nepa17, TreeNum=1)
plot_ZG_output(ZG_output=zg.phase,DOY=c(50,51), Year=2017)
}

}
