% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_taxonomy.R
\name{assign_tax}
\alias{assign_tax}
\title{Assign taxonomy functions}
\usage{
assign_tax(
  analysis_setup,
  asv_abund_matrix,
  retrieve_files = FALSE,
  overwrite_existing = FALSE,
  db_rps10 = "oomycetedb.fasta",
  db_its = "fungidb.fasta",
  db_16S = "bacteriadb.fasta",
  db_other1 = "otherdb1.fasta",
  db_other2 = "otherdb2.fasta"
)
}
\arguments{
\item{analysis_setup}{An object containing directory paths and data tables,
produced by the \code{prepare_reads} function}

\item{asv_abund_matrix}{The final abundance matrix containing amplified sequence variants}

\item{retrieve_files}{Logical, TRUE/FALSE whether to copy files from the temp directory to the output directory. Default is FALSE.}

\item{overwrite_existing}{Logical, indicating whether to remove or overwrite
existing files and directories from previous runs. Default is \code{FALSE}.}

\item{db_rps10}{The reference database for the rps10 metabarcode}

\item{db_its}{The reference database for the ITS metabarcode}

\item{db_16S}{The SILVA 16S-rRNA reference database provided by the user}

\item{db_other1}{The reference database for other metabarcode 1 (assumes format is like SILVA DB entries)}

\item{db_other2}{The reference database for other metabarcode 2 (assumes format is like SILVA DB entries)}
}
\value{
Taxonomic assignments of each unique ASV sequence
}
\description{
Assign taxonomy functions
}
\details{
At this point, 'DADA2' function assignTaxonomy is used to assign taxonomy to the inferred ASVs.
}
\examples{
\donttest{
# Assign taxonomies to ASVs on by metabarcode
analysis_setup <- prepare_reads(
  data_directory = system.file("extdata", package = "demulticoder"),
  output_directory = tempdir(),
  overwrite_existing = TRUE
)
cut_trim(
analysis_setup,
cutadapt_path="/usr/bin/cutadapt",
overwrite_existing = TRUE
)
make_asv_abund_matrix(
analysis_setup,
overwrite_existing = TRUE
)
assign_tax(
analysis_setup,
asv_abund_matrix,
retrieve_files=FALSE,
overwrite_existing = TRUE
)
}
}
