% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_languages2.R
\name{available_languages2}
\alias{available_languages2}
\title{List Supported Languages of the DeepL API Free}
\usage{
available_languages2(auth_key)
}
\arguments{
\item{auth_key}{A string representing the authentication key for the DeepL API Free. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\description{
\code{available_languages2} returns a list of all languages supported by the DeepL API Free.
}
\details{
To use this function, you must obtain an authentication key by registering for a DeepL API Free account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Free}. The function makes an API call to retrieve the 
    list of supported languages and returns them in a structured format.
}
\examples{
\dontrun{
available_languages2()
}

}
\references{
\href{https://developers.deepl.com/docs/getting-started/supported-languages}{DeepL API Documentation on Supported Languages}
}
