% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/words_freq_plot.R
\name{words_freq_plot}
\alias{words_freq_plot}
\title{Graph of most frequent words of each cluster}
\usage{
words_freq_plot(
  x,
  clusters,
  clust_label = NULL,
  n_words = 5,
  words_size = 2,
  axis_size = 1,
  set_colors = NA,
  main = "Most frequent words for each cluster",
  xlabel = "",
  ylabel = ""
)
}
\arguments{
\item{x}{Document-term matrix describing the frequency of terms that occur in a collection of documents. Rows correspond to documents in the collection and columns correspond to terms.}

\item{clusters}{Integer vector of length of the number of cases, which indicates a clustering. The clusters have to be numbered from 1 to the number of clusters.}

\item{clust_label}{Vector of length of the number of cluster containing the cluster names to be displayed (by default \code{"Cluster_1"}, \code{"Cluster_2"}, ...).}

\item{n_words}{Number of words to display.}

\item{words_size}{A numerical value giving the amount by which plotting words should be magnified with respect to the default setting.}

\item{axis_size}{Magnification to be used for axis annotation with respect to the default setting.}

\item{set_colors}{Choose palette for word colors.}

\item{main}{A title for the plot. Default is \code{"Most frequent words for each cluster"}.}

\item{xlabel}{A title for the x-axis. Default is empty.}

\item{ylabel}{A title for the y-axis. Default is empty.}
}
\value{
A graphical aid for visualizing the most frequent terms for each cluster.
}
\description{
Graphical plot of the most frequent words of each cluster
}
\details{
The number of most frequent words to be shown can be set by
\code{n_words} and also clusters names can be passed beforehand as a character
vector to \code{clust_label}
}
\examples{
# Load the CNAE2 dataset
data("CNAE2")

# Perform parameter estimation and clustering
mou_CNAE2 = mou_EM(x = CNAE2, k = 2)

# Usage of the function
words_freq_plot(mou_CNAE2$x, mou_CNAE2$clusters,n_words = 4, words_size = 2, main = "Example" )

}
