% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_move.R
\name{na_move}
\alias{na_move}
\title{Move \code{NA} across columns or rows}
\usage{
na_move(data, cols = names(data), direction = "right")
}
\arguments{
\item{data}{A data.frame without column named "....idx".}

\item{cols}{A character vector of columns' names in \code{data} across which function will be performed. If
\code{NULL}, first column in \code{data} will be used. By default all columns will be used.}

\item{direction}{A character vector of length 1 indicating where to move \code{NA}. Can be one of \code{"top", "right",
"bottom", "left"}. If \code{NULL} and also by default, \code{"right"} direction will be used.}
}
\value{
A data.frame with only these attributes preserved, which are returned by \code{\link[base]{attributes}}
function used on object passed to \code{data} parameter.

Type of columns passed to \code{cols} will be coerced to the most general type, although sometimes when
column will contain only \code{NA}, that column will be of type logical.
}
\description{
For chosen columns, move \code{NA} to right or left (i.e. across columns)
or to top or bottom (i.e. across rows).
}
\note{
To enable parallel computation, call \code{\link[data.table]{setDTthreads}} before calling \code{na_move} function.
}
\examples{
data <- data.frame(col1 = c(1, 2, 3),
                   col2 = c(NA, NA, 4),
                   col3 = c(5, NA, NA),
                   col4 = c(6, 7, 8))
data
na_move(data, c("col2", "col3", "col4"), direction = "right")
}
