#' @importFrom Rlibeemd emd_num_imfs emd
#' @importFrom forecast nnetar forecast
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'
emdTDNN <- function(data, stepahead=10, num.IMFs=emd_num_imfs(length(data)),
                    s.num=4L, num.sift=50L){
  n.IMF <- num.IMFs
  AllIMF <- emd(data, num_imfs = n.IMF, S_number = s.num, num_siftings = num.sift)
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data)-stepahead)+1):length(data)),]
  Fcast_AllIMF <- NULL
  for (IMF in 1:ncol(IMF_trn)) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[ ,IMF]
    emdTDNNFit <- forecast::nnetar(as.ts(IndIMF))
    emdTDNN_fcast=forecast::forecast(emdTDNNFit, h=stepahead)
    emdTDNN_fcast_Mean=emdTDNN_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(emdTDNN_fcast_Mean))
  }
  FinalemdTDNN_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_emdTDNN=mean(abs(data_test - FinalemdTDNN_fcast))
  MAPE_emdTDNN=mean(abs(data_test - FinalemdTDNN_fcast)/data_test)
  rmse_emdTDNN=sqrt(mean((data_test - FinalemdTDNN_fcast)^2))
  Plot_IMFs <- AllIMF
  AllIMF_plots <- plot(Plot_IMFs)
  return(list(TotalIMF = n.IMF, AllIMF=AllIMF, data_test=data_test, AllIMF_forecast=Fcast_AllIMF,
              FinalemdTDNN_forecast=FinalemdTDNN_fcast, MAE_emdTDNN=MAE_emdTDNN,
              MAPE_emdTDNN=MAPE_emdTDNN, rmse_emdTDNN=rmse_emdTDNN,
              AllIMF_plots=AllIMF_plots))
}
