% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.summary.ddt_lcm}
\alias{predict.summary.ddt_lcm}
\title{Prediction of class memberships from posterior summaries}
\usage{
\method{predict}{summary.ddt_lcm}(object, data, ...)
}
\arguments{
\item{object}{a "summary.ddt_lcm" object}

\item{data}{an NxJ matrix of multivariate binary responses, where
N is the number of individuals, and J is the number of granular items}

\item{\dots}{Further arguments passed to each method}
}
\value{
a list of the following named elements:
\describe{
\item{\code{class_assignments}}{an integer vector of individual predicted class memberships
taking values in 1, ..., K}
\item{\code{predictive_probs}}{a N x K matrix of probabilities, where the (i,k)-th element
is the probability that the i-th individual is predicted to belong to class k.}
}
}
\description{
Predict individual class memberships based on posterior summary (point estimates
of model parameters). The predicted class memberships are modal assignments.
}
\examples{
data(result_diet_1000iters)
burnin <- 500
summarized_result <- summary(result_diet_1000iters, burnin, relabel = TRUE, be_quiet = TRUE)
predicted <- predict(summarized_result, result_diet_1000iters$data)
}
