% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flower.R
\name{flower}
\alias{flower}
\title{Display a Rotating Flower Visualization}
\usage{
flower(
  petalCount = 6,
  petalLength = 100,
  petalWidth = 60,
  petalColor = "lightpink",
  petalStroke = "deeppink",
  centerRadius = 20,
  centerColor = "gold",
  centerStroke = "darkorange",
  centerText = NULL,
  centerTextSize = 16,
  centerTextColor = "black",
  font = "Verdana, Geneva, Tahoma, sans-serif",
  bgcol = "white",
  rotationSpeed = 2,
  width = NULL,
  height = NULL
)
}
\arguments{
\item{petalCount}{The number of petals. Defaults to 6.}

\item{petalLength}{The length of each petal. Defaults to 100.}

\item{petalWidth}{The width of each petal. Defaults to 60.}

\item{petalColor}{The fill color of the petals. Defaults to "lightpink".}

\item{petalStroke}{The stroke color of the petals. Defaults to "deeppink".}

\item{centerRadius}{The radius of the flower's center circle. Defaults to 20.}

\item{centerColor}{The fill color of the center. Defaults to "gold".}

\item{centerStroke}{The stroke color of the center. Defaults to "darkorange".}

\item{centerText}{Optional. Text to display inside the center (e.g., a number or emoji).}

\item{centerTextSize}{The size of the center text. Defaults to 16.}

\item{centerTextColor}{The color of the center text. Defaults to "black".}

\item{font}{The font family for the center text. Defaults to "Verdana, Geneva, Tahoma, sans-serif".}

\item{bgcol}{The background color of the visualization. Defaults to "white".}

\item{rotationSpeed}{The speed of rotation (degrees per animation frame). Defaults to 2.}

\item{width}{The width of the SVG output. Optional.}

\item{height}{The height of the SVG output. Optional.}
}
\value{
An animated rotating flower SVG.
}
\description{
Display a Rotating Flower Visualization
}
\examples{
flower(
  petalCount = 5,
  petalColor = "plum",
  rotationSpeed = 1.5
)
}
