% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/level_of_dataset.R
\name{level_of_data}
\alias{level_of_data}
\title{Determine the level / primary key of dataset}
\usage{
level_of_data(dataset, output_filename = "", verbose = TRUE)
}
\arguments{
\item{dataset}{A data.frame}

\item{output_filename}{Name of the output text file (should end in ".txt", although the backend will append if not)
Function's default is "level_of_dataset_<system_time>.txt"}

\item{verbose}{Pass TRUE for detailed output}
}
\value{
Does not return to calling function, writes to file system rather
}
\description{
Knowing the level of dataset is paramount to effectively and efficiently manipulate data, and the level of dataset is unknown oftentimes.
This function checks for count of unique records in all possible column combinations to
determine the level of dataset.
Check for text file generated for column combinations with unique records.
}
\examples{
\dontrun{
level_of_data(dataset = iris[,c("mpg", "cyl", "disp", "hp")], output_filename = "level_mtcars.txt")
}
}
