% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_estimate.R
\name{estimate_classical_wrapper}
\alias{estimate_classical_wrapper}
\title{Internal wrapper for classical estimation of individuals}
\usage{
estimate_classical_wrapper(
  drift_dm_obj,
  obs_data_ids,
  parallelization_strategy = NULL,
  progress = NULL,
  start_vals = NULL,
  optimizer,
  n_cores = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{drift_dm_obj}{a \link{drift_dm} object that will be estimated for
each individual in \code{obs_data_ids}.}

\item{obs_data_ids}{a \link{data.frame} of observed data including an \code{ID}
column that uniquely identifies each individual.}

\item{parallelization_strategy}{an integer, either \code{1} or \code{2}. Strategy \code{1}
parallelizes across individuals, while strategy \code{2} parallelizes within
individuals (only supported for \code{"DEoptim"}). Default is \code{1}}

\item{progress}{an integer, controlling progress output. \code{0} = no progress,
\code{1} = minimal output, \code{2} = progress bar. Default is \code{1}}

\item{start_vals}{an optional \code{data.frame} with starting values for each
individual. Must contain an \code{ID} column matching the IDs in
\code{obs_data_ids}, and one column per parameter.}

\item{seed}{an optional seed to make the results reproducible}

\item{...}{further arguments passed to \code{\link[=estimate_classical]{estimate_classical()}}, including
\code{lower}, \code{upper}, \code{verbose}, \code{control}, \code{round_digits}.
Note that the argument \code{return_runs} is not supported.}
}
\value{
an object of class \code{fits_ids_dm}, which is a list with two
components:
\itemize{
\item \code{drift_dm_fit_info} --- a list containing the model object,
observed data, optimizer information, and convergence messages
\item \code{all_fits} --- a list of individual estimation results
}
}
\description{
This function wraps \code{\link[=estimate_classical]{estimate_classical()}} to handle fitting
multiple individuals in a consistent way. It prepares the data, distributes
the estimation across individuals, and manages parallelization strategies and
progress reporting. Unlike the deprecated \code{estimate_model_ids()}, this
function no longer saves results to disk --- instead, it directly returns an
object of class \code{fits_ids_dm}.
}
\details{
Convergence issues are checked automatically. If one or more individuals
fail to converge, a warning is issued with the corresponding IDs and
messages returned by the optimizer.
}
\seealso{
\code{\link[=estimate_classical]{estimate_classical()}}, \code{\link[=estimate_dm]{estimate_dm()}}
}
\keyword{internal}
