% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_cycle_trend_analysis.r
\name{adaptive_cycle_trend_analysis}
\alias{adaptive_cycle_trend_analysis}
\title{Adaptive Trend and Cycle Analysis for Time Series (universal version)}
\usage{
adaptive_cycle_trend_analysis(
  signal,
  dates,
  dates_type = c("date", "posix", "numeric"),
  normalize = FALSE,
  trendmethod = c("loess", "gam"),
  usefourier = FALSE,
  fourierK = 2,
  auto_fourier_select = TRUE,
  fourier_selection_criterion = c("AICc", "BIC"),
  fourierK_max = 6,
  cimethod = c("model", "bootstrapiid", "bootstrapmbb"),
  nboot = 1000,
  blocksize = NULL,
  seasonalfrequency = 7,
  stlrobust = TRUE,
  specspans = c(7, 7),
  auto_seasonality = TRUE,
  lagmax = NULL,
  loess_span_mode = c("auto_aicc", "auto_gcv", "cv", "fixed"),
  loess_span_fixed = NULL,
  loess_span_grid = seq(0.15, 0.6, by = 0.05),
  loess_cv_k = 5,
  blocklength_mode = c("auto_pwsd", "heuristic", "fixed"),
  blocklength_fixed = NULL,
  robust = TRUE,
  use_gamm = FALSE,
  group_var = NULL,
  group_values = NULL,
  random_effect = NULL,
  cor_struct = c("none", "ar1", "arma"),
  arma_p = 1,
  arma_q = 0,
  forecast_holdout_h = 0,
  forecast_origin_mode = c("expanding", "sliding"),
  train_window = NULL,
  forecast_lock_K = TRUE
)
}
\arguments{
\item{signal}{Numeric vector of observed values.}

\item{dates}{Vector of time indices (Date, POSIXct, or numeric).}

\item{dates_type}{"date", "posix", or "numeric".}

\item{normalize}{Logical; if TRUE, Z score normalization is applied.}

\item{trendmethod}{"loess" or "gam".}

\item{usefourier}{Logical; whether to include Fourier harmonics.}

\item{fourierK}{Integer; fixed number of harmonics if auto selection disabled.}

\item{auto_fourier_select}{Logical; if TRUE, selects K via AICc/BIC.}

\item{fourier_selection_criterion}{"AICc" or "BIC".}

\item{fourierK_max}{Maximum K to consider during selection.}

\item{cimethod}{"model", "bootstrapiid", or "bootstrapmbb".}

\item{nboot}{Number of bootstrap samples.}

\item{blocksize}{Block size for MBB bootstrap.}

\item{seasonalfrequency}{Seasonal frequency for STL (only for dates_type="date").}

\item{stlrobust}{Logical; robust STL decomposition.}

\item{specspans}{Smoothing spans for spectral estimation.}

\item{auto_seasonality}{Logical; if TRUE, uses dominant period.}

\item{lagmax}{Maximum lag for ACF and Ljung Box tests.}

\item{loess_span_mode}{"auto_aicc", "auto_gcv", "cv", "fixed".}

\item{loess_span_fixed}{Numeric; fixed LOESS span.}

\item{loess_span_grid}{Grid of spans for CV.}

\item{loess_cv_k}{Number of folds for blocked CV.}

\item{blocklength_mode}{"auto_pwsd", "heuristic", "fixed".}

\item{blocklength_fixed}{Fixed block length.}

\item{robust}{Logical; robust LOESS or robust GAM family.}

\item{use_gamm}{Logical; fit GAMM instead of GAM.}

\item{group_var}{Character; grouping variable for random intercepts.}

\item{group_values}{Optional vector to attach as grouping variable.}

\item{random_effect}{Optional random effects list for mgcv::gamm.}

\item{cor_struct}{"none", "ar1", "arma".}

\item{arma_p, arma_q}{ARMA orders.}

\item{forecast_holdout_h}{Holdout horizon for forecasting.}

\item{forecast_origin_mode}{"expanding" or "sliding".}

\item{train_window}{Training window for sliding origin.}

\item{forecast_lock_K}{Logical; lock Fourier K across origins.}
}
\value{
A list with:
\itemize{
\item Data (with PlotDate, timenum, Trend, CI, Outlier)
\item Trend
\item CI (lower, upper)
\item Residuals
\item Fourier (K)
\item ChangePoints (in PlotDate scale)
\item Spectrum
\item Plot (Trend, Spectrum)
}
}
\description{
Performs adaptive trend estimation, cycle detection, Fourier harmonic
selection, bootstrap confidence intervals, change points detection, and
rolling-origin forecasting. Supports LOESS, GAM, and GAMM models, and
handles irregular sampling using the Lomb-Scargle periodogram.

Works with:
\itemize{
\item dates_type = "date"   : Date (daily/weekly/monthly data)
\item dates_type = "posix"  : POSIXct (sub-daily, wearable, EEG, sensors)
\item dates_type = "numeric": numeric time (spike trains, simulations)
}
}
