% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_exposure.R
\name{set_exposure}
\alias{set_exposure}
\alias{set_exposure,ANY,ANY-method}
\alias{set_exposure,EffectScenario,data.frame-method}
\alias{set_exposure,EffectScenario,ExposureSeries-method}
\alias{set_exposure,EffectScenario,NoExposureSeries-method}
\alias{set_exposure,EffectScenario,list-method}
\alias{set_exposure,list,list-method}
\alias{set_exposure,list,ANY-method}
\alias{set_exposure,ScenarioSequence,ANY-method}
\title{Set exposure time-series}
\usage{
set_exposure(scenarios, series, ...)

\S4method{set_exposure}{ANY,ANY}(scenarios, series, ...)

\S4method{set_exposure}{EffectScenario,data.frame}(scenarios, series, ...)

\S4method{set_exposure}{EffectScenario,ExposureSeries}(scenarios, series, reset_times = TRUE)

\S4method{set_exposure}{EffectScenario,NoExposureSeries}(scenarios, series, ...)

\S4method{set_exposure}{EffectScenario,list}(scenarios, series, ...)

\S4method{set_exposure}{list,list}(scenarios, series, ...)

\S4method{set_exposure}{list,ANY}(scenarios, series, ...)

\S4method{set_exposure}{ScenarioSequence,ANY}(scenarios, series, ...)
}
\arguments{
\item{scenarios}{\code{vector} of \link{scenarios}}

\item{series}{\code{vector} of  \link{ExposureSeries} objects or a single \code{data.frame}}

\item{...}{additional arguments}

\item{reset_times}{\code{logical}, if \code{TRUE}, the exposure time-series' time points
will be set as output times. Defaults to \code{TRUE}}
}
\value{
\code{list} of \code{EffectScenario} objects
}
\description{
\emph{Exposure} refers to the toxicant concentration an organism is exposed to.
In case of aquatic organisms, this would commonly be the concentration of a
toxicant in water. Other interpretations are possible depending on model
assumptions.
}
\details{
Exposure time-series are generally represented by a \code{data.frame} containing two
columns. The first column for time, the second representing the
exposure level. The ordering of columns is mandatory. The column names
are non-relevant but sensible names may help documenting the
scenario and its data. The \code{data.frame}'s rows must be ordered chronologically.
A time-series can consist of only a single row; in this case it will represent constant
exposure.

For convenience, a time-series with zero exposure can be set using
\code{\link[=set_noexposure]{set_noexposure()}}.
\subsection{Computational efficiency}{

Handling time-series is a costly task for the ODE solver due to consistency
checks and interpolation between time steps. How the solver interpolates
the time-series can be controlled by optional arguments to functions
such as \code{\link[=simulate]{simulate()}} and \code{\link[=effect]{effect()}}. Please refer to \code{\link[=simulate]{simulate()}} for a brief
overview and \link[deSolve:forcings]{deSolve::forcings} for a detailed description.

Exposure time-series should be kept as short as possible and as complex as
needed for optimal computational efficiency.
}

\subsection{Output times}{

By default, the exposure time-series' time points will also be used as output
times of the scenario. Any output times previously set by \code{\link[=set_times]{set_times()}} will
be lost. If this behavior is undesired, set the function argument
\code{reset_times=FALSE}.
}

\subsection{Multiple exposure series and scenarios}{

The functions supports modifying multiple scenarios at once: by
calling it with lists of \link{scenario} and \link{ExposureSeries}
objects. The cartesian product of all scenarios and exposure series will
be returned, iff the parameter \code{expand = TRUE} is set.

As an example for the \emph{expand} mode, two scenarios \code{A} and \code{B} and one
exposure series \code{g} will result in two scenarios \code{Ag} and \code{Bg}, both
using exposure series \code{g}. Two scenarios \code{A} and \code{B} as well as two
exposure seres \code{g} and \code{h} will result in four scenarios \code{Ag},\code{Ah},\code{Bg},
and \code{Bh}.
}
}
\examples{
# Set a data.frame as exposure series
df <- data.frame(time=c(0, 1, 2, 3), conc=c(1, 1, 0, 0))
Lemna_Schmitt() \%>\% set_exposure(df)

# Create and set an ExposureSeries object
es1 <- ExposureSeries(df)
Lemna_Schmitt() \%>\% set_exposure(es1)

# By default, the time points of the exposure series will also be used as
# as output times. To avoid overriding existing output times, set reset_times=FALSE
Lemna_Schmitt() \%>\%
  set_times(0:10) \%>\%
  set_exposure(es1, reset_times=FALSE)

# Setting two series with one function call, creates two scenarios
es2 <- ExposureSeries(data.frame(time=5:10, conc=1))
Lemna_Schmitt() \%>\% set_exposure(c(es1, es2))
}
