% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-algae.R
\name{Algae_Weber}
\alias{Algae_Weber}
\alias{SAM-X}
\alias{AlgaeWeber-class}
\alias{AlgaeWeberScenario-class}
\alias{SamX}
\title{Algae model, \emph{SAM-X} (Weber et al. 2012)}
\usage{
Algae_Weber()

SamX()
}
\value{
an S4 object of type \linkS4class{AlgaeWeber}
}
\description{
The model is a mechanistic combined toxicokinetic-toxicodynamic (TK/TD) and
growth model for algae. The model simulates the development of algal biomass
under laboratory and environmental conditions and was developed by
Weber et al. (2012) as cited in EFSA TKTD opinion (2018). The growth of the
algae population is simulated on the basis of growth rates, which are
dependent on environmental conditions (radiation, temperature, and phosphorus).
The toxicodynamic sub-model describes the effects of growth-inhibiting
substances through a corresponding reduction in the photosynthesis rate on
the basis of internal concentrations.
}
\details{
Deviating from the equations described by Weber et al., this model implementation
uses a user-defined time-series to represent (environmental) concentrations.
Therefore, state-variable \code{C} and its differential equation was removed and
model output \code{C} is identical to the exposure time-series. The implementation
of Weber et al. (2012) was followed where units differ from EFSA (2018).
}
\section{Functions}{
\itemize{
\item \code{SamX()}: Alias using original model name.

}}
\section{State variables}{

The model has three state variables:
\itemize{
\item \code{A}, Biomass (µg fresh wt/mL, cells/mL *10^4)
\item \code{Q}, Mass of phosphorous internal (mg P/L, or µg P/mL)
\item \code{P}, Mass of phosphorous external (mg P/L, or µg P/mL)
}

The original model by Weber et al. contains an additional state variable
\code{C} which models the external stressor concentration. However, the model
implementation in this packages uses a user-defined time-series to represent
environmental concentrations.
Therefore, state variable \code{C} and accompanying parameters are not present here.
}

\section{Model parameters}{

\itemize{
\item Growth model
\itemize{
\item \code{mu_max}, Maximum growth rate (d-1)
\item \code{Q_min}, Minimum intracellular P (µg P/µg fresh wt)
\item \code{Q_max}, Maximum intracellular P (µg P/µg fresh wt)
\item \code{v_max}, Maximum P-uptake rate at non-limited growth (µg P/µg fresh wt/d)
\item \code{k_s},   Half-saturation constant for extracellular P (mg P/L)
\item \code{m_max}, Natural mortality rate (1/d)
\item \code{I_opt}, Optimum light intensity for growth (uE/m²/s)
\item \code{T_opt}, Optimum temperature for growth (°C)
\item \code{T_max}, Maximum temperature for growth (°C)
\item \code{T_min}, Minimum temperature for growth (°C)
\item \code{D}, Dilution rate (1/d)
\item \code{R_0}, Influx concentration of P (mg P/L)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC_50}, Effect concentration of 50\% inhibition of growth rate (µg/L)
\item \code{b}, slope of concentration effect curve at EC_50 (-)
}
}
}

\section{Forcings}{

The Weber model requires two environmental properties as time-series input:
\itemize{
\item \code{T_act}, temperature (°C), and
\item \code{I}, irradiance (uE/m²/s).
}

The following constant default values are used for these properties:
\itemize{
\item \code{T_act} = 23 °C
\item \code{I} = 100 uE/m²/s
}

Forcings time-series are represented by \code{data.frame} objects consisting of two
columns. The first for time and the second for the environmental factor in question.

Entries of the \code{data.frame} need to be ordered chronologically. A time-series
can consist of only a single row; in this case it will represent constant
environmental conditions. See \link{scenarios} for more details.
}

\section{Simulation output}{

Simulation results will contain the state variables Biomass (\code{A}), mass of
internal phosphorous (\code{Q}), mass of external phosphorous (\code{P}) and the external
concentration (\code{C}).

It is possible to amend the output of \code{\link[=simulate]{simulate()}} with additional model
quantities that are not state variables, for e.g. debugging purposes or to
analyze model behavior. To enable or disable additional outputs, use the
optional argument \code{nout} of \code{\link[=simulate]{simulate()}}. As an example, set \code{nout=2} to
enable reporting of external concentration and model derivative \code{dA}.
Set \code{nout=0} to disable additional outputs. The default is \code{nout=1}.

The available output levels are as follows:
\itemize{
\item \code{nout >= 1}: \code{C}, external concentration (µg/L)
\item \code{nout >= 2}: \code{f(T)}, temperature dependence (-)
\item \code{nout >= 3}: \code{f(I)}, light dependence (-)
\item \code{nout >= 4}: \code{f(Q)}, nutrient dependence (-)
\item \code{nout >= 5}: \code{f(Q, P)}, uptake flow reduction (-)
\item \code{nout >= 6}: \code{f(C)}, effect of chemical stressor (-)
\item \code{nout >= 7}: \code{dA}, biomass derivative (µg)
\item \code{nout >= 8}: \code{dQ}, internal phosphorous derivative (mg P/µg fresh wt)
\item \code{nout >= 9}: \code{dP}, external phosphorous derivative (mg P L-1)
}
}

\section{Solver settings}{

The arguments to ODE solver \code{\link[deSolve:ode]{deSolve::ode()}} control how model equations
are numerically integrated. The settings influence stability of the numerical
integration scheme as well as numerical precision of model outputs. Generally, the
default settings as defined by \emph{deSolve} are used, but all \emph{deSolve} settings
can be modified in \emph{cvasi} workflows by the user, if needed. Please refer
to e.g. \code{\link[=simulate]{simulate()}} on how to pass arguments to \emph{deSolve} in \emph{cvasi}
workflows.

Some default settings of \emph{deSolve} were adapted for this model by expert
judgement to enable precise, but also computationally efficient, simulations
for most model parameters. These settings can be modified by the user,
if needed:
\itemize{
\item \code{hmax = 0.1}\if{html}{\out{<br>}}
Maximum step length in time suitable for most simulations.
}
}

\section{Parameter boundaries}{

Default values for parameter boundaries are set for all parameters by expert
judgement, for calibration purposes. Values can be access from the object, and
defaults overwritten.
}

\section{Model history and changes}{

\itemize{
\item cvasi v1.5.0
\itemize{
\item Unused state variable \code{C} and parameter \code{k} removed from documentation
and code. External concentration \code{C} added to simulation output by means
of optional output level \code{nout=1}.
}
}
}

\references{
Weber D, Schaefer D, Dorgerloh M, Bruns E, Goerlitz G, Hammel K, Preuss TG
and Ratte HT, 2012. Combination of a higher-tier flow-through system and
population modeling to assess the effects of time-variable exposure of
isoproturon on the green algae Desmodesmus subspictatus and
Pseudokirchneriella subcapitata. Environmental Toxicology and
Chemistry, 31(4), 899-908. \doi{10.1002/etc.1765}

EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, Brock T, Duquesne S, Grilli S,
Hernandez-Jerez AF, Bennekou SH,Klein M, Kuhl T, Laskowski R, Machera K,
Pelkonen O, Pieper S, Smith RH, Stemmer M, Sundh I, Tiktak A,Topping CJ,
Wolterink G, Cedergreen N, Charles S, Focks A, Reed M, Arena M, Ippolito A,
Byers H andTeodorovic I, 2018. Scientific Opinion on the state of the art of
Toxicokinetic/Toxicodynamic (TKTD)effect models for regulatory risk assessment
of pesticides for aquatic organisms. EFSA Journal, 16(8), 5377.
\doi{10.2903/j.efsa.2018.5377}
}
\seealso{
\link{Scenarios}, \link{Transferable}

Other algae models: 
\code{\link{Algae-models}},
\code{\link{Algae_Simple}()},
\code{\link{Algae_TKTD}()}
}
\concept{algae models}
