% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBsplines.R
\name{IBsplines}
\alias{IBsplines}
\title{Computation of the integral of a cubic B-spline basis over (t0,x) for a given vector of knots}
\usage{
IBsplines(t0, x, knots)
}
\arguments{
\item{t0}{scalar giving lower value of the integration interval.}

\item{x}{vector giving the upper values of the integration interval.}

\item{knots}{vector of knots spanning the desired B-spline basis.}
}
\value{
A matrix of dimension \code{length(x)} by \code{(length(knots)+2)}.

Each integrated cubic B-spline is within a given column.
}
\description{
Computation of the integral of a cubic B-spline basis over (t0,x) for a given vector of knots
}
\examples{
IBsplines(t0=0,x=runif(20),knots=seq(0,1,length=11))
}
