% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_matrix.R
\name{round_matrix}
\alias{round_matrix}
\title{Round a matrix}
\usage{
round_matrix(Y, digits = 0, MARGIN = 0)
}
\arguments{
\item{Y}{A matrix.}

\item{digits}{Decimal places to round to.}

\item{MARGIN}{One of
\itemize{
 \item{0} Preserves the rounded colSums and rowSums.
 \item{1} Preserves the rounded rowSums independently of each other.
 \item{2} Preserves the rounded colSums independently of each other.
}}
}
\value{
The rounded matrix.
}
\description{
Returns an integer matrix that preserves the rounded colSums and rowSums.
}
\details{
The function will throw a *warning* if the problem is infeasable. To be able
to round the matrix in this fashion, the following things must be equal:
\itemize{
 \item {the sum of the differences between the row totals and
 the rounded row totals}
 \item {the sum of the differences between the column totals and
 the rounded row totals}
}
}
\examples{
set.seed(6)
Y <- rnorm(3*5)*10 |> matrix(3,5) |> round(3)
X <- round_matrix(Y)
Y
X
colSums(Y) |> round()
colSums(X)
rowSums(Y) |> round()
rowSums(X)
}
