% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather_extract.R
\name{weather_extract}
\alias{weather_extract}
\title{Extract one or more columns of weather data between two dates}
\usage{
weather_extract(
  data,
  var,
  datevar = NULL,
  ndays = 5,
  startdate = NULL,
  enddate = NULL,
  monitor = FALSE,
  return.dates = TRUE,
  warn.consecutive = TRUE
)
}
\arguments{
\item{data}{Tibble or dataframe of daily weather data}

\item{var}{Variable(s) to be extracted (Default: radn). Several columns
may be specified using column names \code{c(variable1, variable2, ...)}}

\item{datevar}{Date variable specifying day (Default: date_met)}

\item{ndays}{Number of days after/before the start or end date,
respectively. Ignored of both the start and end dates are
specified (Default: 5)}

\item{startdate}{Start date of data to be extracted}

\item{enddate}{Final date of data to be extracted}

\item{monitor}{For debugging. Prints data and dates. (Default:
FALSE)}

\item{return.dates}{A logical indicating whether to return the date
column (Default: TRUE)}

\item{warn.consecutive}{A logical indicating whether to check that
dates are consecutive, that none are missing and provide a warning if
not (Default:TRUE)}
}
\value{
A tibble (data frame) of extracted weather data
}
\description{
Extract column(s) from a tibble/data frame of daily weather data
between two specified dates. Either specify the start and end
dates or specify one of these dates and also the number of days
after or before, respectively.
}
\examples{
library(lubridate)
boonah |>
weather_extract(rain, date = date_met, startdate = ymd("2019-08-16"),
                  enddate = ymd("2019-08-21"))
boonah |>
  weather_extract(rain, startdate = ymd("2019-08-16"),
                  enddate = ymd("2019-08-21"))
boonah |>
  weather_extract(maxt, date = date_met, startdate = ymd("2019-08-16"),
                  ndays = 3, return.dates = FALSE)
boonah |>
  weather_extract(mint, enddate = ymd("2019-08-16"), ndays = 1)
## extract multiple columns
boonah |>
  weather_extract(c(year, day, mint, maxt), enddate = ymd("2019-08-16"),
                  ndays = 3)

}
\seealso{
\code{\link[dplyr]{between}} \code{\link[dplyr]{filter}},
\code{\link{cumulative}}, \code{\link{daily_mean}},
\code{\link{growing_degree_days}}, and \code{\link{stress_days_over}}
}
