% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRISP_functions.R
\name{crispCV}
\alias{crispCV}
\title{CRISP with Tuning Parameter Selection via Cross-Validation.}
\usage{
crispCV(y, X, q = NULL, lambda.min.ratio = 0.01, n.lambda = 50,
  lambda.seq = NULL, fold = NULL, n.fold = NULL, seed = NULL,
  within1SE = FALSE, rho = 0.1, e_abs = 10^-4, e_rel = 10^-3,
  varyrho = TRUE, double.run = FALSE)
}
\arguments{
\item{y}{An n-vector containing the response.}

\item{X}{An n x 2 matrix with each column containing a covariate.}

\item{q}{The desired granularity of the CRISP fit, \code{M.hat}, which will be a \code{q} by \code{q} matrix. \code{M.hat}
is a mean matrix whose element \code{M.hat[i,j]} contains the mean for pairs of covariate values within a quantile range
of the observed predictors \code{X[,1]} and \code{X[,2]}. For example, \code{M.hat[1,2]} represents the
mean of the observations with the first covariate value less than the \code{1/q}-quantile of \code{X[,1]},
and the second covariate value between the \code{1/q}- and \code{2/q}-quantiles of \code{X[,2]}.
If left \code{NULL}, then \code{q=n} is used when n<100, and \code{q=100} is used when n>=100.
We recommend using \code{q<=100} as higher values take longer to fit and provide an unneeded amount of granularity.}

\item{lambda.min.ratio}{The smallest value for \code{lambda.seq}, as a fraction of the maximum lambda value, which is the data-derived
smallest value for which the fit is a constant value. The default is 0.01.}

\item{n.lambda}{The number of lambda values to consider - the default is 50.}

\item{lambda.seq}{A user-supplied sequence of positive lambda values to consider. The typical usage is to calculate
\code{lambda.seq} using \code{lambda.min.ratio} and \code{n.lambda}, but providing \code{lambda.seq} overrides this. If provided,
\code{lambda.seq} should be a decreasing sequence of values, since CRISP relies on warm starts for speed.
Thus fitting the model for a whole sequence of lambda values is often faster than fitting for a single lambda value.}

\item{fold}{User-supplied fold numbers for cross-validation. If supplied, \code{fold} should be an n-vector with entries in 1,...,K when doing K-fold cross-validation. The default is to choose \code{fold} using \code{n.fold}.}

\item{n.fold}{The number of folds, K, to use for the K-fold cross-validation selection of the tuning parameter, lambda. The default is 10 - specification of \code{fold} overrides use of \code{n.fold}.}

\item{seed}{An optional number used with \code{set.seed()} at the beginning of the function. This is only relevant if \code{fold} is not specified by the user.}

\item{within1SE}{Logical value indicating how cross-validated tuning parameters should be chosen. If \code{within1SE=TRUE}, lambda is chosen to be the value corresponding to the most sparse model with cross-validation error within one standard error of the minimum cross-validation error. If \code{within1SE=FALSE}, lambda is chosen to be the value corresponding to the minimum cross-validation error.}

\item{rho}{The penalty parameter for our ADMM algorithm. The default is 0.1.}

\item{e_abs, e_rel}{Values used in the stopping criterion for our ADMM algorithm, and discussed in Appendix C.2 of the CRISP paper.}

\item{varyrho}{Should \code{rho} be varied from iteration to iteration? This is discussed in Appendix C.3 of the CRISP paper.}

\item{double.run}{The initial complete run of our ADMM algorithm will yield sparsity in z_{1i} and z_{2i}, but not
necessarily exact equality of the rows and columns of \code{M.hat}. If \code{double.run} is \code{TRUE}, then the algorithm
is run a second time to obtain \code{M.hat} with exact equality of the appropriate rows and columns. This issue
is discussed further in Appendix C.4 of the CRISP paper.}
}
\value{
An object of class \code{crispCV}, which can be summarized using \code{\link{summary}}, plotted using \code{\link{plot}}, and used to predict outcome values for new covariates using \code{\link{predict}}.
\itemize{
\item{\code{lambda.cv}: }{Optimal lambda value chosen by K-fold cross-validation.}
\item{\code{index.cv}: }{The index of the model corresponding to the chosen tuning parameter, \code{lambda.cv}. That is, \code{lambda.cv=crisp.out$lambda.seq[index.cv]}.}
\item{\code{crisp.out}: }{An object of class \code{crisp} returned by \code{\link{crisp}}.}
\item{\code{mean.cv.error}: }{An m-vector containing cross-validation error where m is the length of \code{lambda.seq}. Note that \code{mean.cv.error[i]} contains the cross-validation error for the tuning parameter \code{crisp.out$lambda.seq[i]}.}
\item{\code{se.cv.error}: }{An m-vector containing cross-validation standard error where m is the length of \code{lambda.seq}. Note that \code{se.cv.error[i]} contains the standard error of the cross-validation error for the tuning parameter \code{crisp.out$lambda.seq[i]}.}
\item{Other elements: }{As specified by the user.}
}
}
\description{
This function implements CRISP, which considers the problem of predicting an outcome variable on the basis of two covariates, using an interpretable yet non-additive model.
CRISP partitions the covariate space into blocks in a data-adaptive way, and fits a mean model within each block. Unlike other partitioning methods,
CRISP is fit using a non-greedy approach by solving a convex optimization problem, resulting in low-variance fits. This function differs
from the \code{\link{crisp}} function in that the tuning parameter, lambda, is automatically selected using K-fold cross-validation.
More details are provided in Petersen, A., Simon, N., and Witten, D. (2016). Convex Regression with Interpretable Sharp Partitions. Journal of Machine Learning Research, 17(94): 1-31 <http://jmlr.org/papers/volume17/15-344/15-344.pdf>.
}
\examples{
\dontrun{
#See ?'crisp-package' for a full example of how to use this package

#generate data (using a very small 'n' for illustration purposes)
set.seed(1)
data <- sim.data(n = 15, scenario = 2)

#fit model and select lambda using 2-fold cross-validation
#note: use larger 'n.fold' (e.g., 10) in practice
crispCV.out <- crispCV(X = data$X, y = data$y, n.fold = 2)
}
}
\seealso{
\code{\link{crisp}}, \code{\link{plot}}, \code{\link{summary}}, \code{\link{predict}}, \code{\link{plot.cvError}}
}

