% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{crimOffenders_df}
\alias{crimOffenders_df}
\title{Criminal Offenders Screened in Florida}
\format{
A data frame with 5,855 observations and 16 variables:
\describe{
  \item{age}{Age of the offender (numeric).}
  \item{juv_fel_count}{Number of juvenile felonies committed (numeric).}
  \item{decile_score}{COMPAS score decile (numeric).}
  \item{juv_misd_count}{Number of juvenile misdemeanors committed (numeric).}
  \item{juv_other_count}{Number of other juvenile convictions (numeric).}
  \item{v_decile_score}{Predicted decile score of the offender (numeric).}
  \item{priors_count}{Number of prior crimes committed (numeric).}
  \item{sex}{Gender of the offender (factor with levels 'Female' and 'Male').}
  \item{two_year_recid}{Recidivism within two years (factor with levels 'Yes' and 'No').}
  \item{race}{Race of the offender (factor with levels 'White', 'Black', 'Hispanic', 'Asian', 'Other', 'Native').}
  \item{c_jail_in}{Date of entry into jail (normalized between 0 and 1, numeric).}
  \item{c_jail_out}{Date of release from jail (normalized between 0 and 1, numeric).}
  \item{c_offense_date}{Date the offense was committed (numeric).}
  \item{screening_date}{Date the offender was screened (numeric).}
  \item{in_custody}{Date the offender was placed in custody (numeric, normalized between 0 and 1).}
  \item{out_custody}{Date the offender was released from custody (numeric, normalized between 0 and 1).}
}
}
\source{
Data collected from criminal offenders screened in Florida during 2013-2014.
}
\usage{
data(crimOffenders_df)
}
\description{
This dataset contains information on criminal offenders who were screened in Florida during 2013-2014.
}
\details{
The dataset name has been changed to 'crimOffenders_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix 'df'
indicates that the dataset is a traditional data frame in R. The original content has not been modified in any way.
}
