% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{training_model}
\alias{training_model}
\title{Training model}
\usage{
training_model(
  model_name = "mymodel",
  dat,
  dat_test = NULL,
  target = NULL,
  occur_time = NULL,
  obs_id = NULL,
  x_list = NULL,
  ex_cols = NULL,
  pos_flag = NULL,
  prop = 0.7,
  split_type = if (!is.null(occur_time)) "OOT" else "Random",
  preproc = TRUE,
  low_var = 0.99,
  missing_rate = 0.98,
  merge_cat = 30,
  remove_dup = TRUE,
  outlier_proc = TRUE,
  missing_proc = "median",
  default_miss = list(-1, "missing"),
  miss_values = NULL,
  one_hot = FALSE,
  trans_log = FALSE,
  feature_filter = list(filter = c("IV", "PSI", "COR", "XGB"), iv_cp = 0.02, psi_cp =
    0.1, xgb_cp = 0, cv_folds = 1, hopper = FALSE),
  algorithm = list("LR", "XGB", "GBM", "RF"),
  LR.params = lr_params(),
  XGB.params = xgb_params(),
  GBM.params = gbm_params(),
  RF.params = rf_params(),
  breaks_list = NULL,
  parallel = FALSE,
  cores_num = NULL,
  save_pmml = FALSE,
  plot_show = FALSE,
  vars_plot = TRUE,
  model_path = tempdir(),
  seed = 46,
  ...
)
}
\arguments{
\item{model_name}{A string, name of the project. Default is "mymodel"}

\item{dat}{A data.frame with independent variables and target variable.}

\item{dat_test}{A data.frame of test data. Default is NULL.}

\item{target}{The name of target variable.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.Default is NULL.}

\item{obs_id}{The name of ID of observations or key variable of data. Default is NULL.}

\item{x_list}{Names of independent variables. Default is NULL.}

\item{ex_cols}{Names of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{prop}{Percentage of train-data after the partition. Default: 0.7.}

\item{split_type}{Methods for partition. See details at :  \code{\link{train_test_split}}.}

\item{preproc}{Logical. Preprocess data. Default is TRUE.}

\item{low_var}{Logical, delete low variance variables or not. Default is TRUE.}

\item{missing_rate}{The maximum percent of missing values for recoding values to missing and non_missing.}

\item{merge_cat}{merge categories of character variables that  is more than m.}

\item{remove_dup}{Logical, if TRUE, remove the duplicated observations.}

\item{outlier_proc}{Logical, process outliers or not. Default is TRUE.}

\item{missing_proc}{If logical, process missing values or not. If "median", then Nas imputation with k neighbors median. If "avg_dist", the distance weighted average method is applied to determine the NAs imputation with k neighbors. If "default", assigning the missing values to -1 or "missing", otherwise ,processing the missing values according to the results of missing analysis.}

\item{default_miss}{Default value of missing data imputation, Defualt is list(-1,'missing').}

\item{miss_values}{Other extreme value might be used to represent missing values, e.g: -9999, -9998. These miss_values will be encoded to -1 or "missing".}

\item{one_hot}{Logical. If TRUE, one-hot_encoding  of category variables. Default is FASLE.}

\item{trans_log}{Logical, Logarithmic transformation. Default is FALSE.}

\item{feature_filter}{Parameters for selecting important and stable features.See details at: \code{\link{feature_selector}}}

\item{algorithm}{Algorithms for training a model. list("LR", "XGB", "GBDT", "RF") are available.}

\item{LR.params}{Parameters of logistic regression & scorecard. See details at :  \code{\link{lr_params}}.}

\item{XGB.params}{Parameters of xgboost. See details at :  \code{\link{xgb_params}}.}

\item{GBM.params}{Parameters of GBM. See details at :  \code{\link{gbm_params}}.}

\item{RF.params}{Parameters of Random Forest. See details at :  \code{\link{rf_params}}.}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{parallel}{Default is FALSE.}

\item{cores_num}{The number of CPU cores to use.}

\item{save_pmml}{Logical, save model in PMML format. Default is TRUE.}

\item{plot_show}{Logical, show model performance in current graphic device. Default is FALSE.}

\item{vars_plot}{Logical, if TRUE, plot distribution ,correlation or partial dependence of model input variables . Default is TRUE.}

\item{model_path}{The path for periodically saved data file. Default is \code{tempdir()}.}

\item{seed}{Random number seed. Default is 46.}

\item{...}{Other parameters.}
}
\value{
A list containing Model Objects.
}
\description{
\code{training_model} Model builder
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
x_list = c("LIMIT_BAL")
B_model = training_model(dat = dat,
                         model_name = "UCICreditCard",
                         target = "default.payment.next.month",
							x_list = x_list,
                         occur_time =NULL,
                         obs_id =NULL,
							dat_test = NULL,
                         preproc = FALSE,
                         outlier_proc = FALSE,
                         missing_proc = FALSE,
                         feature_filter = NULL,
                         algorithm = list("LR"),
                         LR.params = lr_params(lasso = FALSE,
                                               step_wise = FALSE,
                                                 score_card = FALSE),
                         breaks_list = NULL,
                         parallel = FALSE,
                         cores_num = NULL,
                         save_pmml = FALSE,
                         plot_show = FALSE,
                         vars_plot = FALSE,
                         model_path = tempdir(),
                         seed = 46)

}
\seealso{
\code{\link{train_test_split}},\code{\link{data_cleansing}}, \code{\link{feature_selector}},   \code{\link{lr_params}}, \code{\link{xgb_params}}, \code{\link{gbm_params}}, \code{\link{rf_params}},\code{\link{fast_high_cor_filter}},\code{\link{get_breaks_all}},\code{\link{lasso_filter}}, \code{\link{woe_trans_all}}, \code{\link{get_logistic_coef}}, \code{\link{score_transfer}},\code{\link{get_score_card}}, \code{\link{model_key_index}},\code{\link{ks_psi_plot}},\code{\link{ks_table_plot}}
}
