% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_selection.R
\name{get_correlation_group}
\alias{get_correlation_group}
\alias{select_cor_group}
\alias{select_cor_list}
\title{get_correlation_group}
\usage{
get_correlation_group(cor_mat, p = 0.8)

select_cor_group(cor_vars)

select_cor_list(cor_vars_list)
}
\arguments{
\item{cor_mat}{A correlation matrix of independent variables.}

\item{p}{Threshold of correlation between features. Default is 0.7.}

\item{cor_vars}{Correlated variables.}

\item{cor_vars_list}{List of correlated variable}
}
\value{
A list of selected variables.
}
\description{
\code{get_correlation_group} is funtion for  obtaining highly correlated variable groups.
\code{select_cor_group} is funtion for selecting highly correlated variable group.
\code{select_cor_list} is funtion for selecting highly correlated variable list.
}
\examples{
\dontrun{
cor_mat = cor(UCICreditCard[8:20],
use = "complete.obs", method = "spearman")
get_correlation_group(cor_mat, p = 0.6 )
}
}
