% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststats.R
\name{est_null_model}
\alias{est_null_model}
\title{Estimates null model}
\usage{
est_null_model(fit, data, tr_var = "treat", null_par)
}
\arguments{
\item{fit}{An lme4 model object}

\item{data}{The data frame used to fit model fit}

\item{tr_var}{A string indicating the name of the column in data that is a binary indicator
for whether the observation was under the treatment (1=treatment, 0=control)}

\item{null_par}{Numeric the value of tr_var parameter under the null hypothesis}
}
\value{
An lm or glm model fit under the null model
}
\description{
Given an lme4 model object and the value of the treatment effect parameter under the
null hypothesis, the function returns a glm or lm object fitted under the null model
with no cluster effects. For linear models (lmer) the value of the null is subtracted
from the value of the outcome for those in receipt of the treatment and an lm model
is fitted with no treatment effect. For generalised linear models (glmer) the model is
refitted as a glm model with the treatment effect specified as an offset.
}
\examples{
out <- twoarm_sim()
data <- out[[1]]
  fit1 <- lme4::glmer(y1 ~ treat + (1|cl) ,
data=data,
family="poisson")

fit2 <- lme4::glmer(y2 ~ treat + (1|cl),
                    data=data,
                    family="poisson")
fitlist <- list(fit1,fit2)
nullfitlist <- list()
for(i in 1:length(fitlist)){
  nullfitlist[[i]] <- est_null_model(fitlist[[i]],
                                     data,
                                     tr_var = "treat",
                                     null_par = 0)
}
}
