% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covsep.R
\docType{package}
\name{covsep}
\alias{covsep}
\alias{covsep-package}
\title{covsep: tests for determining if the covariance structure of
2-dimensional data is separable}
\description{
Functions for testing if the covariance structure of 2-dimensional data (e.g.
samples of surfaces X_i = X_i(s,t)) is separable, i.e. if cov(X) = C_1 x C_2. 
A complete descriptions of the implemented tests can be found in the paper Aston et al. (2017); see references below.
}
\section{Main functions}{

The main functions are \itemize{
\item \code{\link{clt_test}},
\item \code{\link{gaussian_bootstrap_test}}, 
\item \code{\link{empirical_bootstrap_test}},
\item \code{\link{HS_gaussian_bootstrap_test}},
\item \code{\link{HS_empirical_bootstrap_test}}
}
}

\references{
\cite{Aston, John A. D.; Pigoli, Davide; Tavakoli, Shahin. Tests for
separability in nonparametric covariance operators of random surfaces. Ann.
Statist. 45 (2017), no. 4, 1431--1461. <doi:10.1214/16-AOS1495>.
https://projecteuclid.org/euclid.aos/1498636862}
}
