% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statcovafill.R
\name{stat_covafill}
\alias{stat_covafill}
\title{Add a covafill smoother to an (x,y) plot}
\usage{
stat_covafill(
  mapping = NULL,
  data = NULL,
  geom = "smooth",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  n = 50,
  bandwith = NULL,
  polyDegree = 3L,
  level = 0.95,
  se = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of mappings created by 'aes' from the \code{ggplot2} package. The same as \code{ggplot2::stat_smooth}.}

\item{data}{The data to be displayed in this layer. The same as \code{ggplot2::stat_smooth}.}

\item{geom}{The same as \code{ggplot2::stat_smooth}.}

\item{position}{Position adjustments. The same as \code{ggplot2::stat_smooth}.}

\item{na.rm}{Not used}

\item{show.legend}{Should this legend be displayed? The same as \code{ggplot2::stat_smooth}.}

\item{inherit.aes}{The same as \code{ggplot2::stat_smooth}.}

\item{n}{Number of points to do prediction on.}

\item{bandwith}{Bandwith used in covafill. Uses \code{suggestBandwith} by default.}

\item{polyDegree}{Polynomial degree to use in covafill.}

\item{level}{Level of confidence interval to use.}

\item{se}{Should confidence intervals be displayed?}

\item{...}{Other arguments passed to \code{layer}.}
}
\value{
A \code{ggplot2} \code{layer}.
}
\description{
As an extention to the \code{ggplot2} package, the function adds a covafill fit to an (x,y) plot. The fit is predicted to points on the interval range(x).
}
\seealso{
\code{\link[ggplot2]{stat_smooth}}
}
\author{
Christoffer Moesgaard Albertsen
}
