\name{assoc_ZiR.ZjR}
\alias{assoc_ZiR.ZjR}

\title{
Association between variable \eqn{Z_{iR}} and \eqn{Z_{jR}}.
}
\description{
Finding association between variable \eqn{Z_{R}} at \eqn{i^{th}}{i^th} position and \eqn{Z_{R}} at \eqn{j^{th}}{j^th} position.
Here, the standard normal variable \eqn{Z_{R}} reprsents the occurences of nucleotides A and G at any position based on some threshold value.
}
\usage{
assoc_ZiR.ZjR(x, rZiZj, rZiZjR)
}
\arguments{
  \item{x}{
A dataframe of position wise aligned sequence dataset having A, T, G and C only.
}
  \item{rZiZj}{
An object generated by using the function \code{\link{assoc_Zi.Zj}}.
}
  \item{rZiZjR}{
An object generated by using the function \code{\link{assoc_Zi.ZjR}}.
}
}
\details{
The user has to supply the input dataset as well as the outputs generated from the functions \code{\link{assoc_Zi.Zj}} and \code{\link{assoc_Zi.ZjR}}.

}
\value{
A numeric matrix of order \emph{L} by \emph{L} for the dataset of \emph{L} nucleotides long sequences.
}

\author{
Prabina Kumar Meher & A. R. Rao
}
\note{
It may happen that the convergence will not reach after a ceratin number of iterations and will not produce any output. 
In such situation, the user is advised to exclude or include some positions , or otherwise include or exclude certain sequences.
The user should exploit both options till convergence is reached.
}


\examples{
\donttest{
data(don_dat)
kk <- don_dat[1:300,]
zizj <- assoc_Zi.Zj(x=kk)
zizjr <- assoc_Zi.ZjR(x=kk, rZiZj=zizj)
zirzjr <- assoc_ZiR.ZjR(x=kk, rZiZj=zizj, rZiZjR=zizjr)
zirzjr
}
}
