% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulaboost.R
\name{predict.copulaboost}
\alias{predict.copulaboost}
\title{predict.copulaboost}
\usage{
\method{predict}{copulaboost}(
  object,
  new_x = NULL,
  verbose = FALSE,
  all_parts = FALSE,
  impute_na = TRUE,
  ...
)
}
\arguments{
\item{object}{A copulaboost model object returned from the copulaboost 
function.}

\item{new_x}{A matrix of covariate values to compute predictions for. If
new_x is not provided, the function will return predictions for the
data used for fitting the model.}

\item{verbose}{A logical indicator of whether a progressbar should be
shown in the terminal.}

\item{all_parts}{A logical indicator of whether predictions for the k
first components for k = 1, ..., n_models should be returned as a matrix.
If all_parts = FALSE, only the prediction with all of the model components
is returned.}

\item{impute_na}{A logical indicator of whether any potential NA values 
from any of the predictions from each component should be replaced by the
median prediction for that component.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
If all_parts=FALSE this function will return a list of predictions
for each row of new_x (if specified, otherwise predictions for the 
training data will be returned). If all_parts=TRUE a matrix will be
returned, where the j-th column contains predictions using the j first
model components.
}
\description{
Function that computes predictions for a copulaboost model.
}
